<?php

/**
*
* @package Free Tube Script
* @version v1.0
* @copyright (c) 2011 Agriz
* @license GNU Public License Under Certain Conditions [Powered by should remain unchanged]
* @contact http://www.agrizlive.com
*
*/

	class CategoriesController extends AppController {
		var $name = 'Categories';
		var $helpers = array('Captcha','Html','Form','Time');
		
		function admin_add() {
			if(!empty($this->data)) {
				$this->Category->set($this->data);
				if($this->Category->validates())
				{
					$this->data['Category']['machine_name'] = $this->SeoUrl->makeShortUrl($this->data['Category']['name']);
					$this->Category->create();
					if($this->Category->save($this->data)) {
						$this->Session->setFlash('Category Created Successfully');
					}
					else {
						$this->Session->setFlash('There is a problem in creating new category');
					}
				}
				else {
					$this->Session->setFlash('Form validation failed');
				}			
			}
			$this->set('path_name','categories');
		}
		
		function admin_view() {
			$this->paginate = array('conditions' => array(),'limit' => Configure::read('MyApp.record_per_page'));
			$categories = $this->paginate('Category');
			$this->set(compact('categories'));
			$this->set('path_name','categories');
		}
		
		function admin_edit($id = '') {
			if($id == "") {
				$this->redirect('/admin/categories/view');
			}
			if(!empty($this->data)) {
				$this->Category->create();
				if($this->Category->save($this->data)) {
					$this->Session->setFlash('Category editted Successfully');
				}
				else {
					$this->Session->setFlash('There is a problem in editting category');
				}				
			}
			$categories = $this->data = $this->Category->findById($id);
			$this->set(compact('categories'));
			$this->set('path_name','categories');
		}
		
		function admin_delete($id = '') {
			if($id == "") {
				$this->redirect('/admin/categories/view');
			}
			if($this->Category->delete($id)) {
				$this->Session->setFlash('Category deleted Successfully');
				$this->redirect('/admin/categories/view');
			}
			else {
				$this->Session->setFlash('Category not deleted');
				$this->redirect('/admin/categories/view');
			}
		}
		
		function box() {
			$this->Category->recursive = -1;
			return $categories = $this->Category->find('all');			
		}
		
		function video_by_category($name='',$id='') {
			if($id == '' || $name == '') {
				$this->redirect('/');
			}
			
			$category = $this->Category->find('first',array('conditions' => array('id' => $id,'machine_name' => $name)));
			if(empty($category)) {
				$this->redirect('/');
			}
			
			$this->set('category_name',$category['Category']['name']);
			$this->set('page_name',"video_by_category");
			$this->paginate = array('conditions' => array(array('category_id' => $id)),'limit' => Configure::read('MyApp.record_per_page'));
			$videos = $this->paginate('Video');
			$this->set(compact('videos'));
			
			$this->set('title_for_layout',$category['Category']['name']." videos");
			$this->set('keywords_for_layout','');
			$this->set('description_for_layout','');
			
			//$this->render('videos/');
		}
		
		
	}
?>